<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsQueueTable extends Migration
{
    public function up()
    {
        Schema::create('notifications_queue', function (Blueprint $table) {
            $table->id();
            $table->string('issue_id')->index(); // ID задачи
            $table->string('summary'); // Название задачи или краткое описание
            $table->string('percentage_field_name'); // Название поля с процентом, например, "value_30"
            $table->bigInteger('value'); // Значение поля в миллисекундах (timestamp)
            $table->timestamp('notify_at'); // Дата запланированного уведомления
            $table->boolean('is_notified')->default(false); // Флаг, отправлено ли уведомление
            $table->string('lang')->nullable(); // Язык задачи, например, "Русский" или "English"
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('notifications_queue');
    }
}
