<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class NotificationQueue extends Model
{
    use HasFactory;

    // Таблица, связанная с моделью
    protected $table = 'notifications_queue';

    // Указываем, какие поля можно массово заполнять
    protected $fillable = [
        'issue_id',
        'summary',
        'percentage_field_name',
        'value',
        'notify_at',
        'is_notified',
        'lang'
    ];

    // Атрибуты, которые должны быть приведены к типу даты
    protected $dates = [
        'notify_at',
    ];

    /**
     * Проверка, отправлено ли уведомление.
     *
     * @return bool
     */
    public function isNotified()
    {
        return $this->is_notified;
    }

    /**
     * Устанавливает дату уведомления.
     *
     * @param int $value
     * @return void
     */
    public function setNotifyAtAttribute($value)
    {
        $this->attributes['notify_at'] = Carbon::createFromTimestampMs($value);
    }
}
